//precision highp float;
varying vec2 v_texCoord;
varying vec2 v_viewTexCoord;
uniform float u_lightIntensity;
uniform float u_opacity;

void main()
{
    vec2 texUVCoord = mod(v_texCoord, 1.0);
//    texUVCoord.y = min(v_texCoord.y, 1.0);
    vec4 color = texture2D(CC_Texture1, texUVCoord);
    vec4 lights = vec4(0.0);
    
    if(u_lightIntensity> 0.0){
        lights = texture2D(CC_Texture2, texUVCoord) ;
        color = (1.0-lights.a * u_lightIntensity) * color + lights.a *u_lightIntensity * lights;
    }
  
    
    gl_FragColor = color * u_opacity;
}
